/**
 * A javascript module to handle calendar drag and drop in the calendar
 * month view.
 *
 * @module     core_calendar/month_view_drag_drop
 * @copyright  2017 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_calendar/month_view_drag_drop",["jquery","core/notification","core/str","core_calendar/events","core_calendar/drag_drop_data_store"],(function($,Notification,Str,CalendarEvents,DataStore){var SELECTORS_ROOT="[data-region='calendar']",SELECTORS_DRAGGABLE='[draggable="true"][data-region="event-item"]',SELECTORS_DROP_ZONE='[data-drop-zone="month-view-day"]',SELECTORS_WEEK='[data-region="month-view-week"]',ALL_CLASSES="bg-faded bg-danger text-white bg-primary text-white",registered=!1,getDropZoneFromEvent=function(e){var dropZone=$(e.target).closest(SELECTORS_DROP_ZONE);return dropZone.length?dropZone:null},isValidDropZone=function(dropZone){var dropTimestamp=dropZone.attr("data-day-timestamp"),minTimestart=DataStore.getMinTimestart(),maxTimestart=DataStore.getMaxTimestart();return!(minTimestart&&minTimestart>dropTimestamp)&&!(maxTimestart&&maxTimestart<dropTimestamp)},clearAllDropZonesState=function(){$(SELECTORS_ROOT).find(SELECTORS_DROP_ZONE).each((function(index,dropZone){(dropZone=$(dropZone)).removeClass(ALL_CLASSES)}))},updateHoverState=function updateHoverState(dropZone,hovered,count){void 0===count&&(count=DataStore.getDurationDays());var valid=isValidDropZone(dropZone);if(dropZone.removeClass(ALL_CLASSES),hovered?valid?dropZone.addClass("bg-primary text-white"):dropZone.addClass("bg-danger text-white"):(dropZone.removeClass("bg-primary text-white bg-danger text-white"),valid||dropZone.addClass("bg-faded")),--count>0){var nextDropZone=dropZone.next();if(!nextDropZone.length){var nextWeek=dropZone.closest(SELECTORS_WEEK).next();nextWeek.length&&(nextDropZone=nextWeek.children(SELECTORS_DROP_ZONE).first())}nextDropZone.length&&updateHoverState(nextDropZone,hovered,count)}},updateAllDropZonesState=function(){$(SELECTORS_ROOT).find(SELECTORS_DROP_ZONE).each((function(index,dropZone){dropZone=$(dropZone),isValidDropZone(dropZone)||updateHoverState(dropZone,!1)}))},dragstartHandler=function(e){var draggableElement=$(e.target).closest(SELECTORS_DRAGGABLE);if(draggableElement.length){var eventId=draggableElement.find("[data-event-id]").attr("data-event-id"),minTimestart=draggableElement.attr("data-min-day-timestamp"),maxTimestart=draggableElement.attr("data-max-day-timestamp"),minError=draggableElement.attr("data-min-day-error"),maxError=draggableElement.attr("data-max-day-error"),duration=$(SELECTORS_ROOT+' [data-event-id="'+eventId+'"]').length;DataStore.setEventId(eventId),DataStore.setDurationDays(duration),minTimestart&&DataStore.setMinTimestart(minTimestart),maxTimestart&&DataStore.setMaxTimestart(maxTimestart),minError&&DataStore.setMinError(minError),maxError&&DataStore.setMaxError(maxError),e.dataTransfer.effectAllowed="move",e.dataTransfer.dropEffect="move",e.dataTransfer.setData("text/plain",eventId),e.dropEffect="move",updateAllDropZonesState()}},dragoverHandler=function(e){if(DataStore.hasEventId()){e.preventDefault();var dropZone=getDropZoneFromEvent(e);dropZone&&updateHoverState(dropZone,!0)}},dragleaveHandler=function(e){if(DataStore.hasEventId()){var dropZone=getDropZoneFromEvent(e);dropZone&&(updateHoverState(dropZone,!1),e.preventDefault())}},dropHandler=function(e){if(DataStore.hasEventId()){var dropZone=getDropZoneFromEvent(e);if(!dropZone)return DataStore.clearAll(),void clearAllDropZonesState();if(isValidDropZone(dropZone)){var eventId=DataStore.getEventId(),eventElement=$(SELECTORS_ROOT+' [data-event-id="'+eventId+'"]'),origin=null;eventElement.length&&(origin=eventElement.closest(SELECTORS_DROP_ZONE)),$("body").trigger(CalendarEvents.moveEvent,[eventId,origin,dropZone])}else{var message=function(dropZone){var dropTimestamp=dropZone.attr("data-day-timestamp"),minTimestart=DataStore.getMinTimestart(),maxTimestart=DataStore.getMaxTimestart();return minTimestart&&minTimestart>dropTimestamp?DataStore.getMinError():maxTimestart&&maxTimestart<dropTimestamp?DataStore.getMaxError():null}(dropZone);Str.get_string("errorinvaliddate","calendar").then((function(string){Notification.exception({name:string,message:message||string})}))}DataStore.clearAll(),clearAllDropZonesState(),e.preventDefault()}},dragendHandler=function(){DataStore.clearAll(),clearAllDropZonesState()},calendarMonthChangedHandler=function(){updateAllDropZonesState()};return{init:function(){registered||(document.addEventListener("dragstart",dragstartHandler,!1),document.addEventListener("dragover",dragoverHandler,!1),document.addEventListener("dragleave",dragleaveHandler,!1),document.addEventListener("drop",dropHandler,!1),document.addEventListener("dragend",dragendHandler,!1),$("body").on(CalendarEvents.monthChanged,calendarMonthChangedHandler),registered=!0)}}}));

//# sourceMappingURL=month_view_drag_drop.min.js.map